<?php
// Include the database connection file
require_once 'db.php';

// Set the response header to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the raw JSON data from the request body
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the input data
    if (
        isset($input['latitude']) &&
        isset($input['longitude']) &&
        isset($input['radius']) &&
        isset($input['shippingid'])
    ) {
        // Sanitize the input data (optional, depending on your use case)
        $latitude = $conn->real_escape_string($input['latitude']);
        $longitude = $conn->real_escape_string($input['longitude']);
        $radius = $conn->real_escape_string($input['radius']);
        $shipping_id = $conn->real_escape_string($input['shippingid']);

        // Prepare the SQL query to insert data into the shipping_range table
        $sql = "INSERT INTO shipping_range (shipping_id,latitude, longitude, radius) 
                VALUES ('$shipping_id','$latitude', '$longitude', '$radius')";

        // Execute the query
        if ($conn->query($sql)) {
            // Return a success response
            echo json_encode([
                'status' => 'success',
                'message' => 'Location saved successfully!',
            ]);
        } else {
            // Return an error response if the query fails
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to save location: ' . $conn->error,
            ]);
        }
    } else {
        // Return an error response if required fields are missing
        echo json_encode([
            'status' => 'error',
            'message' => 'Missing required fields.',
        ]);
    }
} else {
    // Return an error response if the request method is not POST
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method.',
    ]);
}

// Close the database connection
$conn->close();
?>